sides = 100;    // number of sides for circles

module lid(fudge=0.1,height=5) {

    d1 = 15;    // diameter of the main body of the pen
    barrel_thickness = 1;   // thickness of the lid
    sprong_thickness = 2;   // amount the grabby sprongs stick out of the lid
    sprong_width = 2.5;     // width of the grabby sprongs
    
    d2 = d1 + 2*barrel_thickness;
    d3 = d2 + 2*sprong_thickness;

    linear_extrude(height)
    minkowski() {
        union() {
            circle(d=10,$fn=sides);
            difference() {
                union() {
                    circle(d=d2,$fn=sides);
                    rotate([0,0,90]) translate([-d3/2,-sprong_width/2]) scale([d3,sprong_width]) square();
                    translate([-d3/2,-sprong_width/2]) scale([d3,sprong_width]) square();
                }
                circle(d=d1,$fn=sides);
            }
        }
        circle(fudge,$fn=20);
    }
}

r = 14;
height = 33;
depth = 6;
fudge = 0.4;
translate([0,0,height/2])
difference() {
    union() {
        rotate([0,0,0]) translate([0,0,-height/2]) cylinder(r=r,h=height,$fn=sides);
        rotate([90,0,0]) translate([0,0,-height/2]) cylinder(r=r,h=height,$fn=sides);
        rotate([0,90,0]) translate([0,0,-height/2]) cylinder(r=r,h=height,$fn=sides);
    }
    union() {
        rotate([0,0,0]) translate([0,0,-height/2-1]) lid(fudge=fudge, height=depth+1);
        rotate([0,0,0]) translate([0,0,height/2-depth+1]) lid(fudge=fudge, height=depth);
        rotate([90,0,0]) translate([0,0,-height/2-1]) lid(fudge=fudge, height=depth);
        rotate([90,0,0]) translate([0,0,height/2-depth+1]) lid(fudge=fudge, height=depth);
        rotate([0,90,0]) translate([0,0,-height/2-1]) lid(fudge=fudge, height=depth);
        rotate([0,90,0]) translate([0,0,height/2-depth+1]) lid(fudge=fudge, height=depth);
    }
}
