length = 80;
width = 10;
height = 5;
fudge = 0.4;

module fudged_cube(fudge=fudge) {
    scale([length+2*fudge,width+2*fudge,height+2*fudge]) cube();
}

module rod() {
    difference() {
        fudged_cube(fudge=0);
        union() {
            translate([width+fudge,0,-height/2-fudge]) rotate([0,0,90]) fudged_cube();
            translate([length+fudge,0,-height/2-fudge]) rotate([0,0,90]) fudged_cube();
            translate([length/4+width+fudge,0,height/2-fudge]) rotate([0,0,90]) fudged_cube();
            translate([3*length/4+fudge,0,height/2-fudge]) rotate([0,0,90]) fudged_cube();
        }
    }
}
rotate([90,0,0]) rod();
//color("blue") translate([length/4+width,0,0]) rotate([0,0,90]) rod();