length = 20;
spacing = 0.5;

p_offset = length * 9 / 16 + spacing / 2;
n_offset = -length * 7 / 16 - spacing / 2;
convex_radius = length / 8 - spacing / 2;
concave_radius = length / 8 + spacing / 2;

$fn=24;

module starter() {
    union() {
        square(length, center = true);
        translate([p_offset, 0]) 
            circle(convex_radius);
        translate([0, p_offset]) 
            circle(convex_radius);
}
}

module piece() {
    difference() {
        starter();
        translate([n_offset, 0]) 
        circle(concave_radius);
    translate([0, n_offset]) 
        circle(concave_radius);
    }
}
module piece1() {
    union() {
linear_extrude(1)
piece();
        translate([-4,-3,1])
        linear_extrude(1)
        text("1");
    }
}

piece1();

module piece2() {
    difference() {
linear_extrude(2)
piece();
        translate([-4,-3,1])
        linear_extrude(1)
        text("2");
    }
}

translate([25,0,0])
piece2();
translate([0,25,0])
piece2();

module piece4() {
    difference() {
linear_extrude(4)
piece();
        translate([-4,-3,3])
        linear_extrude(1)
        text("4");
    }
}

translate([25,25,0])
piece4();
translate([75,0,0])
piece4();
translate([0,75,0])
piece4();

module piece3() {
    difference() {
linear_extrude(3)
piece();
        translate([-4,-3,2])
        linear_extrude(1)
        text("3");
    }
}

translate([50,0,0])
piece3();
translate([0,50,0])
piece3();

module piece6() {
    difference() {
linear_extrude(6)
piece();
        translate([-4,-3,5])
        linear_extrude(1)
        text("6");
    }
}

translate([50,25,0])
piece6();
translate([25,50,0])
piece6();

module piece5() {
    difference() {
linear_extrude(5)
piece();
        translate([-4,-3,4])
        linear_extrude(1)
        text("5");
    }
}

translate([100,0,0])
piece5();
translate([0,100,0])
piece5();

module piece8() {
    difference() {
linear_extrude(8)
piece();
        translate([-4,-3,7])
        linear_extrude(1)
        text("8");
    }
}

translate([75,25,0])
piece8();
translate([25,75,0])
piece8();

module piece9() {
    difference() {
linear_extrude(9)
piece();
        translate([-4,-3,8])
        linear_extrude(1)
        text("9");
    }
}

translate([50,50,0])
piece9();

module piece12() {
    difference() {
linear_extrude(12)
piece();
        translate([-5,-3,11])
        linear_extrude(1)
        text("12", size=8);
    }
}

translate([75,50,0])
piece12();
translate([50,75,0])
piece12();

module piece10() {
    difference() {
linear_extrude(10)
piece();
        translate([-5,-3,9])
        linear_extrude(1)
        text("10", size=8);
    }
}

translate([100,25,0])
piece10();
translate([25,100,0])
piece10();

module piece15() {
    difference() {
linear_extrude(15)
piece();
        translate([-5,-3,14])
        linear_extrude(1)
        text("15", size=8);
    }
}

translate([100,50,0])
piece15();
translate([50,100,0])
piece15();

module piece20() {
    difference() {
linear_extrude(20)
piece();
        translate([-5,-3,19])
        linear_extrude(1)
        text("20", size=8);
    }
}

translate([100,75,0])
piece20();
translate([75,100,0])
piece20();

module piece16() {
    difference() {
linear_extrude(16)
piece();
        translate([-5,-3,15])
        linear_extrude(1)
        text("16", size=8);
    }
}

translate([75,75,0])
piece16();

module piece25() {
    difference() {
linear_extrude(25)
piece();
        translate([-5,-3,24])
        linear_extrude(1)
        text("25", size=8);
    }
}
translate([100,100,0])
piece25();