depth = 0.2;
thickness = 0.2;
steps = 50;
in = false;
width=0.2;

module curve() {
function f(x,y) = cos(x*180/5)*sin(y*180/5)*1;

function lowest(x1,y1,x2,y2) = 
    min([for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        f(x, y)
    ])
;

module plot(x1=-5,y1=-5,x2=5,y2=5, depth=0.2) {
    f_points = [
        for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        [x,y, f(x, y)]
    ];
        
    lowest = lowest(x1,y1,x2,y2)-depth;
        
    points = concat([
        [x1,y1,lowest],
        [x1,y2,lowest],
        [x2,y1,lowest],
        [x2,y2,lowest]],
        f_points
    );
    
    tops = concat(
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i, 4+j*steps+i+1, 4+(j+1)*steps+i]
        ],
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i+1, 4+(j+1)*steps+i+1, 4+(j+1)*steps+i]
        ]
    );
    sides = concat(
        [
            concat([1], [for(i=[steps-1:-1:0]) i+4], [0]),
            concat([0], [for(i=[0:steps]) i*steps+4], [2]),
            concat([3], [for(i=[steps-1:-1:0]) (i+1)*steps+3], [1]),
            concat([2], [for(i=[0:steps-1]) (steps-1)*steps+i+4], [3]), //y
            [0,2,3,1]
        ]
    );
            
    faces = concat(tops,sides);
        
    translate([0,0,-lowest])
    polyhedron(points,faces);
            
}
    
module slice(y,thickness,in=true) {
    if(in==true) {
        intersection() {        
            children();
            translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    } else {
        difference() {
            children();
        //    translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    }
}

origin = depth-lowest(-5,-5,5,5);

slice(in=in, origin, thickness=thickness) plot(depth=depth);
}


curve();



module allcrosses() {
module crosses() {
rotate([0,0,45])
translate([0,1.59,1])
cube([12,width,4],center=true);
rotate([0,0,-45])
translate([0,-1.59,1])
cube([12,width,4],center=true);
}
crosses();
rotate([0,0,180])
crosses();
}

*allcrosses();

module lines() {
    intersection(){
        curve();
        allcrosses();
        translate([0,0,1])
        *curve();
    }
}

module thinlines() {
    difference() {
        lines();
        translate([0,0,-width])
        lines();
    }
}

translate([0,0,width])
thinlines();