module saddle() {
    function f(x, y) = ((pow(x,2)/5)-(pow(y,2)/5));

min_value = -3;
max_value = 3;
resolution = 0.5;
thickness = 1;

points = [
    for(y = [min_value:resolution:max_value])
        [
            for(x = [min_value:resolution:max_value]) 
                [x, y, f(x, y)]
        ]
];

faces = [
    [0, 1, 2],
    [3, 4, 5],
    [0, 1, 4, 3],
    [1, 2, 5, 4],
    [2, 0, 3, 5]
];
z_offset = [0, 0, -thickness];

for(yi = [0:len(points) - 2]) {
    for(xi = [0:len(points[yi]) - 2]) {
        tri1_top = [
            points[yi][xi], 
            points[yi][xi + 1], 
            points[yi + 1][xi + 1]
        ];
        tri1_bottom = [
            tri1_top[0] + z_offset, 
            tri1_top[1] + z_offset, 
            tri1_top[2] + z_offset
        ];

        tri2_top = [
            points[yi][xi], 
            points[yi + 1][xi + 1], 
            points[yi + 1][xi]
        ];
        tri2_bottom = [
            tri2_top[0] + z_offset, 
            tri2_top[1] + z_offset, 
            tri2_top[2] + z_offset
        ];

        // hull them to avoid non-attached faces
        hull() polyhedron(
                points = concat(tri1_top, tri1_bottom), 
                faces = faces
            );

         hull() polyhedron(
                points = concat(tri2_top, tri2_bottom), 
                faces = faces
            );
    }
}
}

module line1() {
    difference() {
    intersection() {
        translate([0,0,0.3])
        saddle();
        cube([20,0.3,20],center=true);
    }
    intersection() {
        saddle();
        cube([20,0.3,20],center=true);
    }
}
}

module line2() {
    difference() {
    intersection() {
        translate([0,0,0.3])
        saddle();
        cube([0.3,20,20],center=true);
    }
    intersection() {
        saddle();
        cube([0.3,20,20],center=true);
    }
}
}


*saddle();
translate([0,0,-1])
*saddle();

module circle1() {
    intersection(){
        translate([4,0,0])
    sphere(d=9);
        translate([0,0,5])
        cube(10,center=true);
        }
}

module circle2() {
    intersection(){
        translate([-4,0,0])
    sphere(d=9);
        translate([0,0,5])
        cube(10,center=true);
        }
}

module circles() {
circle1();
circle2();
}

translate([0,0,-4])
*circles();

module cutcircles() {
    intersection(){
        circles();
        cube(6,center=true);
    }
}

module base() {
cutcircles();
    translate([0,0,1])
    cube([6,6,2],center=true);
    translate([2.5,0,3])
    cube([1,4,1.6],center=true);
    translate([-2.5,0,3])
    cube([1,4,1.6],center=true);
}

translate([0,0,-4])
*base();

module lines() {
line1();
line2();
}

lines();