module allparts() {
module triangle() {
    polygon(points=[[0,0],[2,0],[1,sqrt(3)]]);
}

module sphinx() {
triangle();
translate([2,0,0])
triangle();
translate([4,0,0])
triangle();
translate([1,sqrt(3),0])
triangle();
rotate([0,0,180])
translate([-3,-sqrt(3),0])
triangle();
rotate([0,0,180])
translate([-5,-sqrt(3),0])
triangle();
}

scaling=1;

module slot() {
difference() {
    translate([-0.5,-0.3,0])
    linear_extrude(height=0.5)
    scale(1.3)
    sphinx();
    translate([0,0,0])
    linear_extrude(height=0.5)
    sphinx();
}
}

scale(3.3*scaling)
slot();

translate([34,-1,0])
rotate([0,0,90])
scale(2.2*scaling)
slot();

translate([-1,15,0])
linear_extrude(height=1)
scale(scaling)
sphinx();

translate([6,15,0])
linear_extrude(height=1)
scale(scaling)
sphinx();

translate([13,15,0])
linear_extrude(height=1)
scale(scaling)
sphinx();

translate([20,15,0])
linear_extrude(height=1)
scale(scaling)
sphinx();

translate([-1,20,0])
linear_extrude(height=1)
scale(scaling)
sphinx();

translate([6,20,0])
linear_extrude(height=1)
scale(scaling)
sphinx();

translate([13,20,0])
linear_extrude(height=1)
scale(scaling)
sphinx();

translate([20,20,0])
linear_extrude(height=1)
scale(scaling)
sphinx();

translate([28,21,0])
rotate([0,0,-90])
linear_extrude(height=1)
scale(scaling)
sphinx();
}

scale(3)
allparts();