// Number of the tray to print
n = 2; // [2:20] 

// Number of rows and columns in the grid
ROWS = 5; // [2:20]

// Radius of each hole
R = 2; // [0.5:0.1:5]

// Minimum space between holes
SPACE = 2; // [0:0.05:10]

// Thickness of the tray
DEPTH = 3; // [0.5:0.1:10]

// Width of the connector
CONNECTOR_SIZE = 2;

// Depth of the connector
CONNECTOR_DEPTH = 1;

// Width of the lip
LIP = 4; // [0.5:0.1:10]

// Wiggle room so trays can stack
SQUIDGE = 0.5; // [0.1:0.1:2]



function lip(n) = LIP;

module base(n) {
    size = ROWS*R*2 + (ROWS-1)*SPACE + 2*LIP;
    m = (LIP-CONNECTOR_SIZE)/2;
    om = size - m - CONNECTOR_SIZE;
    squidge = CONNECTOR_SIZE+2*SQUIDGE;
    c = (LIP - squidge)/2;
    oc = size - c - squidge;
    difference() {
        union() {
            scale([size,size,DEPTH]) cube();
            translate([m,m,DEPTH])
                scale([CONNECTOR_SIZE, CONNECTOR_SIZE, CONNECTOR_DEPTH]) cube();
            translate([om,m,DEPTH])
                scale([CONNECTOR_SIZE, CONNECTOR_SIZE, CONNECTOR_DEPTH]) cube();
            translate([m,om,DEPTH])
                scale([CONNECTOR_SIZE, CONNECTOR_SIZE, CONNECTOR_DEPTH]) cube();
            translate([om,om,DEPTH])
                scale([CONNECTOR_SIZE, CONNECTOR_SIZE, CONNECTOR_DEPTH]) cube();
        }
        union() {
            translate([c,c,0])
                scale([squidge, squidge, CONNECTOR_DEPTH]) cube();
            translate([oc,c,0])
                scale([squidge, squidge, CONNECTOR_DEPTH]) cube();
            translate([c,oc,0])
                scale([squidge, squidge, CONNECTOR_DEPTH]) cube();
            translate([oc,oc,0])
                scale([squidge, squidge, CONNECTOR_DEPTH]) cube();
        }
    }
}

module holes(n) {
    gap = (R*2 + SPACE);
    margin =  R + LIP;
    for(x=[0:ROWS-1], y=[0:ROWS-1]) {
        t = x*ROWS + y;
        if((t+1)%n!=0) {
            translate([x*gap + margin, y*gap + margin,0]) 
            cylinder(r=R,h=2*DEPTH,$fn=20);
        }
    }
    tx = (n-1)%ROWS;
    ty = (n-1-tx)/ROWS;
    translate([ty*gap + margin, tx*gap + margin,DEPTH/2]) 
    linear_extrude(height=DEPTH,center=false) 
    rotate([0,0,90]) 
    text(str(n),size=R+SPACE,halign="center",valign="center", font=":style=Bold");
}

module tray(n) {
    difference() {
        base(n);
        holes(n);
    }
}

module stack(t) {
    for(n=[2:t]) {
        translate([0,0,-(n-2)*DEPTH*1.5]) 
        tray(n);
    }
}

tray(n);

*intersection() {
    stack(5);
    translate([5,5,0]) cube(100);
}
