length=100;
height=2;
base=2;
outwards=0.75;
strut=5;

module axis() {
difference() {
    translate([0,-2*height,-2*height])
    cube([length+height,3*height,3*height]);
    translate([0,-height,height])
    scale(height)
    rotate([-45,0,0])
    cube([length+height,3*height,3*height]);
}
}
axis();

module peg() {
translate([0,-outwards/2,-outwards/2])
rotate([-45,0,0])
cylinder(h=2*height,r=height/2,$fn=20);
translate([0,2-outwards/2,2-outwards/2])
rotate([-45,0,0])
cylinder(h=3*height/4,r=2*height/2,$fn=20);
}

module pegaxis() {
for (i=[1:10]){
    translate([i*length/10,0,0])
    peg();
}
axis();
}

pegaxis();
rotate([90,0,90])
pegaxis();
rotate([0,-90,-90])
pegaxis();

module struts() {
    intersection() {
for (i=[0:9]) {
    translate([(2.2+(1.4*i))*strut,(2.3+(1.4*i))*strut,-4.5])
    rotate([45,0,-45])
    cylinder(h=3.7*strut+(2*i*1.4*strut),r=height/3);
}
translate([0,0,-4])
cube(length+4);
}
}

struts();
translate([0,-3,-4])
rotate([0,0,45])
cube([110,5,2]);