module Menger1() {
module cube1() {
    cube(9);
}

module cube2() {
    difference(){
        cube1();
        translate([0,3,3])
        cube([9,3,3]);
        translate([3,0,3])
        cube([3,9,3]);
        translate([3,3,0])
        cube([3,3,9]);
    }
}

module holex() {
    for(i = [0 : 2]) 
        translate([0,1,((i*3)+1)])
    cube([9,1,1]);
}

module cube3() {
    difference() {
        cube2();
        holex();
        translate([0,3,0])
        holex();
        translate([0,6,0])
        holex();
        rotate([0,0,90])
        translate([0,-6,0])
        holex();
        rotate([0,0,90])
        translate([0,-3,0])
        holex();
        rotate([0,0,90])
        translate([0,-9,0])
        holex();
        rotate([0,90,0])
        translate([-9,0,0])
        holex();
        rotate([0,90,0])
        translate([-9,3,0])
        holex();
        rotate([0,90,0])
        translate([-9,6,0])
        holex();
    }
}

cube3();
translate([9,0,0])
cube3();
translate([18,0,0])
cube3();
translate([0,9,0])
cube3();
translate([0,18,0])
cube3();
translate([18,9,0])
cube3();
translate([9,18,0])
cube3();
translate([18,18,0])
cube3();
translate([0,0,9])
cube3();
translate([18,0,9])
cube3();
translate([0,18,9])
cube3();
translate([18,18,9])
cube3();
translate([0,0,18])
cube3();
translate([9,0,18])
cube3();
translate([18,0,18])
cube3();
translate([0,9,18])
cube3();
translate([0,18,18])
cube3();
translate([18,9,18])
cube3();
translate([9,18,18])
cube3();
translate([18,18,18])
cube3();
}

scale(10/9)
Menger1();

module Menger2() {
    difference() {
        cube(27);
        Menger1();
        translate([0,9,9])
        cube([27,9,9]);
        translate([9,0,9])
        cube([9,27,9]);
        translate([9,9,0])
        cube([9,9,27]);
    }
}

//translate([40,0,0])
//Menger2();
