depth = 0.2;
thickness = 0.2;
steps = 50;
in = false;
width=0.2;
scale=1;

// First part
module curve1() {
function f(x,y) = scale*2*sin(180*x/5);

function lowest(x1,y1,x2,y2) = 
    min([for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        f(x, y)
    ])
;

module plot(x1=-4*PI,y1=-3,x2=6*PI,y2=3, depth=0.2) {
    f_points = [
        for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        [x,y, f(x, y)]
    ];
        
    lowest = lowest(x1,y1,x2,y2)-depth;
        
    points = concat([
        [x1,y1,lowest],
        [x1,y2,lowest],
        [x2,y1,lowest],
        [x2,y2,lowest]],
        f_points
    );
    
    tops = concat(
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i, 4+j*steps+i+1, 4+(j+1)*steps+i]
        ],
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i+1, 4+(j+1)*steps+i+1, 4+(j+1)*steps+i]
        ]
    );
    sides = concat(
        [
            concat([1], [for(i=[steps-1:-1:0]) i+4], [0]),
            concat([0], [for(i=[0:steps]) i*steps+4], [2]),
            concat([3], [for(i=[steps-1:-1:0]) (i+1)*steps+3], [1]),
            concat([2], [for(i=[0:steps-1]) (steps-1)*steps+i+4], [3]), //y
            [0,2,3,1]
        ]
    );
            
    faces = concat(tops,sides);
        
    translate([0,0,-lowest])
    polyhedron(points,faces);
            
}
    
module slice(y,thickness,in=true) {
    if(in==true) {
        intersection() {        
            children();
            translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    } else {
        difference() {
            children();
        //    translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    }
}

origin = depth-lowest(-5,-5,5,5);

slice(in=in, origin, thickness=thickness) plot(depth=depth);
}
// First 2 parts
module curve2() {
function f(x,y) = scale*(2*(sin(180*x/5))-sin(2*180*x/5));

function lowest(x1,y1,x2,y2) = 
    min([for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        f(x, y)
    ])
;

module plot(x1=-4*PI,y1=-3,x2=6*PI,y2=3, depth=0.2) {
    f_points = [
        for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        [x,y, f(x, y)]
    ];
        
    lowest = lowest(x1,y1,x2,y2)-depth;
        
    points = concat([
        [x1,y1,lowest],
        [x1,y2,lowest],
        [x2,y1,lowest],
        [x2,y2,lowest]],
        f_points
    );
    
    tops = concat(
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i, 4+j*steps+i+1, 4+(j+1)*steps+i]
        ],
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i+1, 4+(j+1)*steps+i+1, 4+(j+1)*steps+i]
        ]
    );
    sides = concat(
        [
            concat([1], [for(i=[steps-1:-1:0]) i+4], [0]),
            concat([0], [for(i=[0:steps]) i*steps+4], [2]),
            concat([3], [for(i=[steps-1:-1:0]) (i+1)*steps+3], [1]),
            concat([2], [for(i=[0:steps-1]) (steps-1)*steps+i+4], [3]), //y
            [0,2,3,1]
        ]
    );
            
    faces = concat(tops,sides);
        
    translate([0,0,-lowest])
    polyhedron(points,faces);
            
}
    
module slice(y,thickness,in=true) {
    if(in==true) {
        intersection() {        
            children();
            translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    } else {
        difference() {
            children();
        //    translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    }
}

origin = depth-lowest(-5,-5,5,5);

slice(in=in, origin, thickness=thickness) plot(depth=depth);
}

//First 3 parts
module curve3() {
function f(x,y) = scale*(2*(sin(180*x/5))-sin(2*180*x/5)+(2/3)*sin(3*180*x/5));

function lowest(x1,y1,x2,y2) = 
    min([for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        f(x, y)
    ])
;

module plot(x1=-4*PI,y1=-3,x2=6*PI,y2=3, depth=0.2) {
    f_points = [
        for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        [x,y, f(x, y)]
    ];
        
    lowest = lowest(x1,y1,x2,y2)-depth;
        
    points = concat([
        [x1,y1,lowest],
        [x1,y2,lowest],
        [x2,y1,lowest],
        [x2,y2,lowest]],
        f_points
    );
    
    tops = concat(
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i, 4+j*steps+i+1, 4+(j+1)*steps+i]
        ],
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i+1, 4+(j+1)*steps+i+1, 4+(j+1)*steps+i]
        ]
    );
    sides = concat(
        [
            concat([1], [for(i=[steps-1:-1:0]) i+4], [0]),
            concat([0], [for(i=[0:steps]) i*steps+4], [2]),
            concat([3], [for(i=[steps-1:-1:0]) (i+1)*steps+3], [1]),
            concat([2], [for(i=[0:steps-1]) (steps-1)*steps+i+4], [3]), //y
            [0,2,3,1]
        ]
    );
            
    faces = concat(tops,sides);
        
    translate([0,0,-lowest])
    polyhedron(points,faces);
            
}
    
module slice(y,thickness,in=true) {
    if(in==true) {
        intersection() {        
            children();
            translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    } else {
        difference() {
            children();
        //    translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    }
}

origin = depth-lowest(-5,-5,5,5);

slice(in=in, origin, thickness=thickness) plot(depth=depth);
}

//First 4 parts
module curve4() {
function f(x,y) = scale*(2*(sin(180*x/5))-(sin(2*180*x/5))+((2/3)*sin(3*180*x/5))-((2/4)*sin(4*180*x/5)));

function lowest(x1,y1,x2,y2) = 
    min([for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        f(x, y)
    ])
;

module plot(x1=-4*PI,y1=-3,x2=6*PI,y2=3, depth=0.2) {
    f_points = [
        for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        [x,y, f(x, y)]
    ];
        
    lowest = lowest(x1,y1,x2,y2)-depth;
        
    points = concat([
        [x1,y1,lowest],
        [x1,y2,lowest],
        [x2,y1,lowest],
        [x2,y2,lowest]],
        f_points
    );
    
    tops = concat(
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i, 4+j*steps+i+1, 4+(j+1)*steps+i]
        ],
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i+1, 4+(j+1)*steps+i+1, 4+(j+1)*steps+i]
        ]
    );
    sides = concat(
        [
            concat([1], [for(i=[steps-1:-1:0]) i+4], [0]),
            concat([0], [for(i=[0:steps]) i*steps+4], [2]),
            concat([3], [for(i=[steps-1:-1:0]) (i+1)*steps+3], [1]),
            concat([2], [for(i=[0:steps-1]) (steps-1)*steps+i+4], [3]), //y
            [0,2,3,1]
        ]
    );
            
    faces = concat(tops,sides);
        
    translate([0,0,-lowest])
    polyhedron(points,faces);
            
}
    
module slice(y,thickness,in=true) {
    if(in==true) {
        intersection() {        
            children();
            translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    } else {
        difference() {
            children();
        //    translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    }
}

origin = depth-lowest(-5,-5,5,5);

slice(in=in, origin, thickness=thickness) plot(depth=depth);
}

//First 5 parts
module curve5() {
function f(x,y) = scale*(2*(sin(180*x/5))-(sin(2*180*x/5))+((2/3)*sin(3*180*x/5))-((2/4)*sin(4*180*x/5))+(2/5)*sin(5*180*x/5));

function lowest(x1,y1,x2,y2) = 
    min([for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        f(x, y)
    ])
;

module plot(x1=-4*PI,y1=-3,x2=6*PI,y2=3, depth=0.2) {
    f_points = [
        for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        [x,y, f(x, y)]
    ];
        
    lowest = lowest(x1,y1,x2,y2)-depth;
        
    points = concat([
        [x1,y1,lowest],
        [x1,y2,lowest],
        [x2,y1,lowest],
        [x2,y2,lowest]],
        f_points
    );
    
    tops = concat(
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i, 4+j*steps+i+1, 4+(j+1)*steps+i]
        ],
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i+1, 4+(j+1)*steps+i+1, 4+(j+1)*steps+i]
        ]
    );
    sides = concat(
        [
            concat([1], [for(i=[steps-1:-1:0]) i+4], [0]),
            concat([0], [for(i=[0:steps]) i*steps+4], [2]),
            concat([3], [for(i=[steps-1:-1:0]) (i+1)*steps+3], [1]),
            concat([2], [for(i=[0:steps-1]) (steps-1)*steps+i+4], [3]), //y
            [0,2,3,1]
        ]
    );
            
    faces = concat(tops,sides);
        
    translate([0,0,-lowest])
    polyhedron(points,faces);
            
}
    
module slice(y,thickness,in=true) {
    if(in==true) {
        intersection() {        
            children();
            translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    } else {
        difference() {
            children();
        //    translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    }
}

origin = depth-lowest(-5,-5,5,5);

slice(in=in, origin, thickness=thickness) plot(depth=depth);
}



// First 10 parts
module curve10() {
function f(x,y) = scale*((2*(sin(180*x/5)))-(sin(2*180*x/5))+((2/3)*sin(3*180*x/5))-((2/4)*sin(4*180*x/5))+((2/5)*sin(5*180*x/5))-((2/6)*sin(6*180*x/5))+((2/7)*sin(7*180*x/5))-((2/8)*sin(8*180*x/5))+((2/9)*sin(9*180*x/5))-((2/10)*sin(10*180*x/5)));

function lowest(x1,y1,x2,y2) = 
    min([for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        f(x, y)
    ])
;

module plot(x1=-4*PI,y1=-3,x2=6*PI,y2=3, depth=0.2) {
    f_points = [
        for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        [x,y, f(x, y)]
    ];
        
    lowest = lowest(x1,y1,x2,y2)-depth;
        
    points = concat([
        [x1,y1,lowest],
        [x1,y2,lowest],
        [x2,y1,lowest],
        [x2,y2,lowest]],
        f_points
    );
    
    tops = concat(
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i, 4+j*steps+i+1, 4+(j+1)*steps+i]
        ],
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i+1, 4+(j+1)*steps+i+1, 4+(j+1)*steps+i]
        ]
    );
    sides = concat(
        [
            concat([1], [for(i=[steps-1:-1:0]) i+4], [0]),
            concat([0], [for(i=[0:steps]) i*steps+4], [2]),
            concat([3], [for(i=[steps-1:-1:0]) (i+1)*steps+3], [1]),
            concat([2], [for(i=[0:steps-1]) (steps-1)*steps+i+4], [3]), //y
            [0,2,3,1]
        ]
    );
            
    faces = concat(tops,sides);
        
    translate([0,0,-lowest])
    polyhedron(points,faces);
            
}
    
module slice(y,thickness,in=true) {
    if(in==true) {
        intersection() {        
            children();
            translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    } else {
        difference() {
            children();
        //    translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    }
}

origin = depth-lowest(-5,-5,5,5);

slice(in=in, origin, thickness=thickness) plot(depth=depth);
}

// First 20 parts
module curve20() {
function f(x,y) = scale*((2*(sin(180*x/5)))-(sin(2*180*x/5))+((2/3)*sin(3*180*x/5))-((2/4)*sin(4*180*x/5))+((2/5)*sin(5*180*x/5))-((2/6)*sin(6*180*x/5))+((2/7)*sin(7*180*x/5))-((2/8)*sin(8*180*x/5))+((2/9)*sin(9*180*x/5))-((2/10)*sin(10*180*x/5))+((2/11)*sin(11*180*x/5))-((2/12)*sin(12*180*x/5))+((2/13)*sin(13*180*x/5))-((2/14)*sin(14*180*x/5))+((2/15)*sin(15*180*x/5))-((2/16)*sin(16*180*x/5))+((2/17)*sin(17*180*x/5))-((2/18)*sin(18*180*x/5))+((2/19)*sin(19*180*x/5))-((2/20)*sin(20*180*x/5)));

function lowest(x1,y1,x2,y2) = 
    min([for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        f(x, y)
    ])
;

module plot(x1=-4*PI,y1=-3,x2=6*PI,y2=3, depth=0.2) {
    f_points = [
        for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        [x,y, f(x, y)]
    ];
        
    lowest = lowest(x1,y1,x2,y2)-depth;
        
    points = concat([
        [x1,y1,lowest],
        [x1,y2,lowest],
        [x2,y1,lowest],
        [x2,y2,lowest]],
        f_points
    );
    
    tops = concat(
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i, 4+j*steps+i+1, 4+(j+1)*steps+i]
        ],
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i+1, 4+(j+1)*steps+i+1, 4+(j+1)*steps+i]
        ]
    );
    sides = concat(
        [
            concat([1], [for(i=[steps-1:-1:0]) i+4], [0]),
            concat([0], [for(i=[0:steps]) i*steps+4], [2]),
            concat([3], [for(i=[steps-1:-1:0]) (i+1)*steps+3], [1]),
            concat([2], [for(i=[0:steps-1]) (steps-1)*steps+i+4], [3]), //y
            [0,2,3,1]
        ]
    );
            
    faces = concat(tops,sides);
        
    translate([0,0,-lowest])
    polyhedron(points,faces);
            
}
    
module slice(y,thickness,in=true) {
    if(in==true) {
        intersection() {        
            children();
            translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    } else {
        difference() {
            children();
        //    translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    }
}

origin = depth-lowest(-5,-5,5,5);

slice(in=in, origin, thickness=thickness) plot(depth=depth);
}

//y=x
module line() {
function f(x,y) = (x);

function lowest(x1,y1,x2,y2) = 
    min([for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        f(x, y)
    ])
;

module plot(x1=-4*PI,y1=-3,x2=-2*PI+2.5,y2=3, depth=0.2) {
    f_points = [
        for (i=[0:steps-1], j=[0:steps-1], x=(x2-x1)*i/(steps-1) + x1, y=(y2-y1)*j/(steps-1) + y1)
        [x,y, f(x, y)]
    ];
        
    lowest = lowest(x1,y1,x2,y2)-depth;
        
    points = concat([
        [x1,y1,lowest],
        [x1,y2,lowest],
        [x2,y1,lowest],
        [x2,y2,lowest]],
        f_points
    );
    
    tops = concat(
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i, 4+j*steps+i+1, 4+(j+1)*steps+i]
        ],
        [
            for(i=[0:steps-2], j=[0:steps-2])
            [4+j*steps+i+1, 4+(j+1)*steps+i+1, 4+(j+1)*steps+i]
        ]
    );
    sides = concat(
        [
            concat([1], [for(i=[steps-1:-1:0]) i+4], [0]),
            concat([0], [for(i=[0:steps]) i*steps+4], [2]),
            concat([3], [for(i=[steps-1:-1:0]) (i+1)*steps+3], [1]),
            concat([2], [for(i=[0:steps-1]) (steps-1)*steps+i+4], [3]), //y
            [0,2,3,1]
        ]
    );
            
    faces = concat(tops,sides);
        
    translate([0,0,-lowest])
    polyhedron(points,faces);
            
}
    
module slice(y,thickness,in=true) {
    if(in==true) {
        intersection() {        
            children();
            translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    } else {
        difference() {
            children();
        //    translate([-1000,-1000,y-thickness/2]) scale([2000,2000,thickness]) cube();
        }
    }
}

origin = depth-lowest(-5,-5,5,5);

slice(in=in, origin, thickness=thickness) plot(depth=depth);
}




//ALL
module curves() {
//n=1
    translate([4*PI,0,0]){
    curve1();
}

//n=2
translate([4*PI,6,0]) {
curve2();
}



//n=3
    *translate([4*PI,12,0])
    *curve3();

//n=4
translate([4*PI,12,0]) {
curve4();
}



//n=5
    *translate([4*PI,24,0])
    *curve5();

//n=10
translate([4*PI,18,0]) {
curve10();
}

//n=20
translate([4*PI,24,0]) {
curve20();
}

//line
    *translate([((2*PI+2.5)*i)+4*PI,24,0]){ 
    *line();
}

}

//base with text on
module textbase() {
difference() {
cube([30,10*PI,3]);
    translate([3,16,1])
    linear_extrude(height=2)
    text("First n terms of the",size=2);
    translate([2,12,1])
    linear_extrude(height=2)
    text("Fourier series for y=x",size=2);
        rotate([90,180,180])
        translate([1,-2,30.5])
        linear_extrude(height=2)
        text("n=1",size=2);
        rotate([90,180,180])
        translate([6.5,-2,30.5])
        linear_extrude(height=2)
        text("n=2",size=2);
        rotate([90,180,180])
        translate([12.5,-2,30.5])
        linear_extrude(height=2)
        text("n=4",size=2);
        rotate([90,180,180])
        translate([18,-2,30.5])
        linear_extrude(height=2)
        text("n=10",size=1.8);
        rotate([90,180,180])
        translate([24.2,-2,30.5])
        linear_extrude(height=2)
        text("n=20",size=1.8);
}
}



module all() {
curves();
translate([0,-3,0])
rotate([0,180,-90])
textbase();
}

all();