hole_r=4.2;
margin=0.4;
segments = 50;

module flat_piece(length, h, spacing, w) {
    translate([-length/2*spacing,0])
    union() {
        circle(w,$fn=segments);
        translate([length*spacing,0]) circle(w,$fn=segments);
        translate([0,-w]) scale([length*spacing,2*w]) square();
    }
}

module piece(length, h=2, spacing=20, w = 7) {
    difference() {
        linear_extrude(h) flat_piece(length,h,spacing,w);
        translate([-length/2*spacing,0])
      #  for(i=[0:length]) {
            translate([i*spacing,0]) cylinder(r=hole_r, h=h,$fn=segments);
        }
    }
}

length = 3;
translate([0,0,0]) piece(length);


cylinder_r=hole_r-margin;
sphere_r=hole_r+margin;

module plinth() {
cube([14,14,2],center=true);
cylinder(h=30,r=cylinder_r);
    translate([0,0,20])
    sphere(sphere_r);
}

translate([0,18,0])
plinth();

translate([20,18,0])
plinth();

translate([-20,18,0])
plinth();