module cone() {
    cylinder(h=100,r1=20,r2=0);
}

module holytop() {
    difference() {
        cone();
        translate([0,0,35])
        cube(70,center=true);
        cylinder(h=80,r=3,$fn=40);
    }
}

module holycircle() {
    difference() {
        cone();
        holytop();
        translate([0,0,34])
        cube(69,center=true);
        cylinder(h=80,r=3,$fn=40);
    }
}

module ellipse(){
    intersection() {
        cone();
        rotate([20,0,0])
        translate([0,0,60])
        cube([60,60,2],center=true);
    }
}

module holyellipse(){
    difference() {
        ellipse();
        cylinder(h=80,r=3,$fn=40);
    }
}

module holypiece2() {
    difference() {
     cone();
        holytop();
        holycircle();
        holyellipse();
        translate([0,0,28])
        rotate([20,0,0])
        cube(67,center=true);
        cylinder(h=80,r=3,$fn=40);
    }
}

module parabola() {
    intersection() {
        cone();
        rotate([65,0,0])
        translate([0,10,10])
        cube([80,80,2], center=true);
    }
}

module holyparabola() {
    difference() {
        parabola();
        cylinder(h=80,r=3,$fn=40);
    }
}

module holypiece3() {
    difference() {
        cone();
        holytop();
        holycircle();
        holyellipse();
        holypiece2();
        holyparabola();
        translate([0,23,11])
        rotate([65,0,0])
        cube(51,center=true);
        cylinder(h=80,r=3,$fn=40);
    }
}

module peggyhyperbola() {
    intersection() {
        cone();
        translate([0,33,20])
       cube(40,center=true);
    }
    rotate([90,0,0])
    translate([0,10,-15])
    cylinder(h=8,r=2.2,$fn=40);
}

module holypiece4() {
    difference() {
    cone();
        holytop();
        holycircle();
        holyellipse();
        holypiece2();
        holyparabola();
        holypiece3();
        translate([0,33,20])
       cube(40,center=true);
        rotate([90,0,0])
    translate([0,10,-15])
    cylinder(h=8,r=2.5);
        cylinder(h=80,r=3,$fn=40);
        }
}

module stand() {
    cylinder(r=25,h=4);
    cylinder(r=2.5,h=80,$fn=40);
}

translate([80,0,-70])
holytop();
translate([60,0,-68.5])
holycircle();
translate([80,0,-59])
rotate([-20,0,0])
holyellipse();
translate([60,30,68.5])
rotate([0,180,0])
holypiece2();
translate([25,0,-9])
rotate([-65,0,0])
holyparabola();
translate([-20,0,-11])
rotate([-65,0,0])
holypiece3();
translate([20,50,0])
peggyhyperbola();
translate([-20,-30,0])
holypiece4();
translate([40,-40,0])
stand();