\name{jointplot}
\alias{jointplot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Joint plot of longitudinal and survival data}
\description{
  This function views the longitudinal profile of each unit with
  the last longitudinal measurement prior to event-time (censored or not) taken as the end-point, referred to as
  time zero. In doing so, the shape of the profile prior to event-time
  can be inspected. This can be done over a user-specified number of
  time units. 
}
\usage{
jointplot(longdat, survdat, lag = max(longdat[,3]), split = TRUE, col1
= "blue", col2 = "red")
}

\arguments{
  \item{longdat}{a matrix containing both the longitudinal data and
    the longitudinal design matrix. The matrix will contain one row per
    measurement per subject. The matrix is required to have the column
    form: subject index, longitudinal response, longitudinal measurement
    time, longitudinal design matrix.}
  \item{survdat}{matrix containing both the survival data and the survival
    design matrix and must contain one row per subject. The matrix is
    required to be set up in the following column order: subject index,
    survival time, censoring indicator, survival design matrix.}
  \item{lag}{Argument which specifies how many units in time we look
    back through. Defaults to the maximum observation time across all units.}
  \item{split}{\code{TRUE}/\code{FALSE} argument which allows the profiles of units which \sQuote{fail} and
    those which are \sQuote{censored} to be viewed in separate panels of the
    same graph. This is the default option. Using \code{split = FALSE} will plot all
    profiles overlaid on a single plot.}
  \item{col1}{argument to choose the colour for the profiles of the
    \sQuote{censored} units. If \code{split = FALSE} then this also the
    colour used for all profiles.}
  \item{col2}{argument to choose the colour for the profiles of the
    \sQuote{failed} units.}
}
\details{
  The function tailors the \code{xyplot} function in \pkg{lattice} to
  produce a representation of joint data with longitudinal and survival
  components. 
}

\references{Wulfsohn, M. S. and Tsiatis, A. A. (1997) \sQuote{A Joint Model for Survival
  and Longitudinal Data Measured with Error}, \emph{Biometrics}, \bold{53}, 330-339.}
\author{Pete Philipson \email{p.m.philipson@ncl.ac.uk}}

\seealso{\code{xyplot},\code{joint},\code{jointcp}.}
\examples{
data(liverlong,liversurv)
jointplot(liverlong,liversurv,lag=8)
}

\keyword{models}
\keyword{survival}
