\name{jointcp}
\alias{jointcp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Fit joint model with a change-point for survival and longitudinal data measured with
  error}
\description{
This generic function fits a joint model with random latent association,
building on the formulation
described in Wulfsohn and Tsiatis (1997) while allowing for
  the presence of longitudinal and survival covariates, and a piecewise
  linear change-point model for the latent process. The link between the longitudinal and
  survival processes is assumed to be proportional.
}
\usage{
jointcp(longdat, survdat, longsep = FALSE, survsep = FALSE, gpt =3,
max.it = 200, tol = 0.001, lgpt = 10, cp = 1)}

%- maybe also 'usage' for other objects documented here.
\arguments{
  
  \item{longdat}{a matrix containing both the longitudinal data and
    the longitudinal design matrix. The matrix will contain one row per
    measurement per subject. The matrix is required to have the column
    form: subject index, longitudinal response, longitudinal measurement
    time, longitudinal design matrix.}
  \item{survdat}{matrix containing both the survival data and the survival
    design matrix and must contain one row per subject. The matrix is
    required to be set up in the following column order: subject index,
    survival time, censoring indicator, survival design matrix.}
  \item{longsep}{if \code{TRUE}, parameter estimates and log-likelihood from a
    separate analysis of the longitudinal data (see the \code{lme} function
    in the package \pkg{nlme} for details) are returned.}
  \item{survsep}{if \code{TRUE}, parameter estimates and log-likelihood from a
    separate analysis of the survival data using the Cox proportional
    hazards model are returned (see \code{coxph} in the \pkg{survival} package for
    details).}
  \item{gpt}{the number of quadrature points across which the
    integration with respect to the random effects will be
    performed. Defaults to \code{gpt=3} which produces stable estimates in most
    datasets.}
  \item{max.it}{the maximum number of iterations which the function will
    perform. Defaults to \code{max.it=200}, though more iterations may be
    necessary for large, complex data.}
  \item{tol}{the tolerance level before convergence of the algorithm is
    deemed to have occurred. Default value is \code{tol=0.001}.}
  \item{lgpt}{the number of quadrature points which the log-likelihood
    is evaluated over following a model fit. This defaults to \code{lgpt=10},
    though \code{lgpt=3} is often sufficient.}
  \item{cp}{the point at which the change-point in the piecewise model
    occurs. Defaults to \code{cp=1}, and must be greater than one and less than
    the study duration.}
}
    \details{
  The function uses an EM algorithm to estimate parameters in the
  joint model. Starting values are provided by calls to standard R
  functions 'lme' and 'coxph' for the longitudinal and survival
  components respectively.
}
\value{
A list containing the parameter estimates from the joint model
and, if required, from either or both of the separate analyses. The
combined log-likelihood from a separate analysis and the log-likelihood
from the joint model are also produced as part of the fit.
}
\references{The general approach and model formulation is described by
  Wulfsohn, M. S. and Tsiatis, A. A.

  Wulfsohn, M. S. and Tsiatis, A. A. (1997) "A Joint Model for Survival
  and Longitudinal Data Measured with Error", Biometrics, 53, 330-339.}
  
  \author{Pete Philipson (p.m.philipson@ncl.ac.uk)}
  
\note{Both 'longsep' and 'survsep' ignore any latent association between
the longitudinal and survival processes but output can be used to
compare with the results from the joint model. If interest is solely in
the individual processes then the user should instead make use of the
functions 'lme' and 'coxph' mentioned above. 
}

\seealso{'lme','coxph','joint','jointsep','jointplot'.}
\examples{
data(heartlong,heartsurv)
fit1=jointcp(heartlong,heartsurv)
}

\keyword{models}% at least one, from doc/KEYWORDS
\keyword{survival}
