"jointplot"<-function(longdat,survdat,lag=max(longdat[,3]),split=TRUE,col1="blue",col2="red"){
t=longdat[,3]
Y=longdat[,2]
id=longdat[,1]
nobs=diff(match(unique(id),id))
nobs[length(nobs)+1]=length(id)-sum(nobs)
index=cumsum(nobs)
cens=survdat[,3]
ft=rep(t[index],nobs)
t0=t-ft
hue=length(id)
ii=(cens==0)
hue[ii]=col1
hue[!ii]=col2
fac=rep(cens,nobs)
ii=(fac==0)
fac[ii]="censored"
fac[!ii]="failed"
if(split==TRUE){
xyplot(Y~t0|fac,groups=id,type="l",lty=1,xlim=c(-lag,0),col=hue,xlab="time",ylab="Y")}
else{
xyplot(Y~t0,groups=id,type="l",xlim=c(-lag,0),col=col1,xlab="time",ylab="Y")}
}
