"jointcp"<-function(longdat,survdat,longsep=FALSE,survsep=FALSE,gpt=3,max.it=200,tol=0.001,lgpt=10,cp=1){

ran=3

"sep"<-function(ests,logical){
  if(logical==FALSE){ests="No separate results requested"}
  ests}

"longst"<-function(longdat,ran,cp){
id=longdat[,1]
Y=longdat[,2]
X1=longdat[,4:dim(longdat)[2]]
tt=longdat[,3]
ii=tt>cp
tta=tt
ttb=tt-cp
tta[ii]=cp
ttb[!ii]=0
long.start=lme(Y~X1-1,random=~(tta+ttb)|id,method="ML")
sigu=diag(as.double(VarCorr(long.start)[1:3,1]))
rho=as.double(c(VarCorr(long.start)[2,3],VarCorr(long.start)[3,3:4]))
v=tcrossprod(diag(sqrt(sigu)))*upper.tri(sigu)
sigu[upper.tri(sigu)]=v[v!=0]*rho
sigu=sigu+t(sigu)-diag(as.double(VarCorr(long.start)[1:3,1]))
rownames(sigu)<-paste("U",0:(ran-1),sep='')
colnames(sigu)<-paste("U",0:(ran-1),sep='')
vare=long.start$sigma^2
ll=long.start$logLik
b1=fixef(long.start)
names(b1)<-NULL
list(b1=data.frame(b1),vare=vare,sigu=sigu,log.like=ll)
}

"survst"<-function(survdat){
n=length(survdat[,2])
s=survdat[,2]
cen=survdat[,3]
if(cen[1]==0){cen[1]=1}
p2=dim(survdat)[2]-3
if(p2==0){surv.start<-coxph(Surv(s,cen)~0)}
if(p2>0){
  X2=as.matrix(survdat[,4:dim(survdat)[2]])
  surv.start<-coxph(Surv(s,cen)~X2)}
alpha.0=basehaz(surv.start,FALSE)
nf=length(alpha.0[,2])
haz=diff(c(0,alpha.0[,1]))
sf=alpha.0[,2]
rs=rep(1:nf,c(diff(match(sf,s)),n+1-match(sf,s)[nf]))
nev=diff(c(match(1:length(sf),match(s[cen==1],sf)),sum(cen)+1))
b2=coef(surv.start)
names(b2)<-NULL
noties=(nf==sum(cen))
if(noties){ll=surv.start$loglik[2]-sum(cen)}
else{ll=tiedsurvlike(survdat,b2,haz,sf,rs)}
list(b2=b2,haz=haz,rs=rs,sf=sf,nev=nev,log.like=ll)
}

"tiedsurvlike"<-function(survdat,b2,haz,sf,rs){
s=survdat[,2]
cen=survdat[,3]
if(cen[1]==0){cen[1]=1}
p2=dim(survdat)[2]-3
if(p2==0){X2=0}
if(p2>0){X2=as.matrix(survdat[,4:dim(survdat)[2]])}
bX=X2%*%b2
f=match(s,sf)*cen
f[is.na(f)]=0
chaz=cumsum(haz)
l1=log(haz[f])+bX[cen==1]
l2=chaz[rs]*exp(bX)
ll=sum(l1)-sum(l2)
ll
}

"em.alg"<-function(longdat,survdat,ran,paraests,gpt,max.it,tol,cp){
id=longdat[,1]
Y=longdat[,2]
tt=longdat[,3]
X1=longdat[,4:dim(longdat)[2]]
n=length(survdat[,2])
s=survdat[,2]
cen=survdat[,3]
p1=dim(X1)[2]
p2=dim(survdat)[2]-3
X2=0
if(p2>0){X2=as.matrix(survdat[,4:dim(survdat)[2]])}
b1=paraests$b1[,1]
sigu=paraests$sigu
tsigu=t(sigu)
vare=paraests$vare
b2=c(paraests$b2,0)
b2x=matrix(0,n,1)
haz=paraests$haz
sf=paraests$sf
rs=paraests$rs
nev=paraests$nev
nn=diff(match(unique(id),id))
nn=c(nn,length(id)-sum(nn))
N=sum(nn)
lat=1
g=gauss.quad.prob(gpt,"normal",sigma=sqrt(0.5))
ab=g$nodes
w=g$weights*sqrt(pi)
gmat=matrix(0,gpt^ran,ran)
gmat[,1]=rep(ab,each=gpt^(ran-1))
gmat[,2]=rep(ab,gpt)
w=as.vector(w%x%w)
gmat[,3]=rep(ab,each=gpt)
w=as.vector(w%x%g$weights*sqrt(pi))
EU=matrix(0,n,ran)
EUU=matrix(0,n,sum(1:ran))
EexpU=matrix(0,n,length(haz))
EUexpU=matrix(0,n,ran)
EUUexpU=matrix(0,n,sum(1:ran))
r=Y-X1%*%b1
s1=rep(1:(ran-1),(ran-1):1)
s2=sequence((ran-1):1)+rep(1:(ran-1),(ran-1):1)
Dtt=getD(ran,tt,cp)
Dttb=t(Dtt)
Dttc=t(getD(sum(1:ran)-ran,tt,cp))
Dttc=Dttc[,s1]*Dttc[,s2]
Ds=getD(ran,s,cp) 
Dsf=getD(ran,sf,cp)
Dsf2=Dsf^2
Dsfc=Dsf[s1,]*Dsf[s2,]
Dnsf=matrix(1,ran,length(sf))
cnn=c(0,cumsum(nn))
Inn=diag(max(nn))
conv=FALSE
for (it in 1:max.it){
if(p2>0){b2x=X2%*%b2[1:p2]}
eb2x=exp(b2x)
varei=vare*Inn
cov=sigu%*%Dtt
tcov=Dttb%*%sigu
DH=Dnsf*rep(haz,each=ran)
for (i in 1:n){
rv=r[(cnn[i]+1):cnn[i+1]]
ttv=Dttb[(cnn[i]+1):cnn[i+1],]
W21=cov[,(cnn[i]+1):cnn[i+1]]
W12=tcov[(cnn[i]+1):cnn[i+1],]
W11=ttv%*%W21+varei[1:nn[i],1:nn[i]]
if(nn[i]==1){
W3=W12/W11
cvch=chol((sigu-tcrossprod(W21,W3))*2)
cm=matrix(W3*rv,gpt^ran,ran,TRUE)}
else{W3=solve(W11,W12)
cvch=chol((sigu-W21%*%W3)*2)
cm=matrix(rv%*%W3,gpt^ran,ran,TRUE)}
newu=gmat%*%cvch+cm
newu2=newu^2
newu2=cbind(newu2,newu[,s1]*newu[,s2])
egDUs=1
if(cen[i]==1){egDUs=exp(b2[p2+lat]*(newu%*%Ds[,i]))}
egDUsf=exp(b2[p2+lat]*(newu%*%Dsf[,1:rs[i]]))
ess=exp(-(eb2x[i,]*egDUsf)%*%haz[1:rs[i]])
f=egDUs*ess*w
den=sum(f)
EU[i,1:ran]=f[,1]%*%newu/den
EUU[i,1:sum(1:ran)]=f[,1]%*%newu2/den
C=egDUsf[,1:rs[i]]
EexpU[i,1:rs[i]]=f[,1]%*%C/den
EUexpU[i,1:ran]=rowSums(crossprod(newu*f[,1],C)*Dsf[,1:rs[i]]*DH[,1:rs[i]])/den 
EUUexpU[i,1:ran]=rowSums(crossprod(newu2[,1:ran]*f[,1],C)*Dsf2[,1:rs[i]]*DH[,1:rs[i]])/den
EUUexpU[i,(ran+1):sum(1:ran)]=2*rowSums(crossprod(newu2[,(ran+1):sum(1:ran)]*f[,1],C)*Dsfc[,1:rs[i]]*DH[,1:rs[i]])/den
}
parac<-data.frame(c(b1,b2,vare,sigu))
EexpUi=colSums(t(EexpU)*haz)
haz=nev/colSums(EexpU*exp(b2x[,1]))
EUmat<-apply(EU,2,rep,nn)
EUUmat<-apply(EUU,2,rep,nn)
Ut=rowSums(EUmat*Dttb)
UUt=rowSums(EUUmat[,1:ran]*Dttb^2)
UUt2=rowSums(EUUmat[,(ran+1):sum(1:ran)]*Dttc)
b1=solve(crossprod(X1),crossprod(X1,Y-Ut))
r=Y-X1%*%b1
vare=sum(r^2-2*r*Ut+UUt+2*UUt2)/N
diag(sigu)<-colMeans(EUU)[1:ran]
sigu[lower.tri(sigu)]=colMeans(EUU)[-(1:ran)]
sigu[upper.tri(sigu)]=t(sigu)[upper.tri(sigu)]
fd<-vector("numeric",p2+lat)
sd<-matrix(0,p2+lat,p2+lat)
if(p2>0){
fd[1:p2]=c(colSums((cen*X2)-(X2*eb2x[,1]*EexpUi)))
sd[1:p2,p2+lat]=-colSums((X2*eb2x[,1]*rowSums(EUexpU)))
sd=sd+t(sd)
for (i in 1:p2){
for (j in 1:p2){
sd[i,j]=(-sum(X2[,i]*X2[,j]*eb2x*EexpUi))}}}
fd[p2+lat]=sum(cen*(EU*t(Ds)))-sum(eb2x*rowSums(EUexpU))
sd[p2+lat,p2+lat]=-sum(eb2x*(rowSums(EUUexpU)))
b2=b2-solve(sd,fd)
para<-data.frame(c(b1,b2,vare,sigu))
dd=abs(parac-para)
if(max(dd)<tol){conv=TRUE
break}
}
if(conv!=TRUE){print("Not converged")}
list(b1=data.frame(b1),b2=data.frame(b2),vare=vare,sigu=sigu,haz=haz,conv=conv,iters=it)
}

"getD"<-function(q,arg,cp=1){D=matrix(0,q,length(arg))
D[1,]=1
D[2,]=arg
ii=arg>=cp
D[2,ii]=cp
D[3,]=arg-cp
D[3,!ii]=0
D}

"jlike"<-function(longdat,survdat,ran,likeests,lgpt,cp){
id=longdat[,1]
Y=longdat[,2]
tt=longdat[,3]
X1=as.matrix(longdat[,4:dim(longdat)[2]])
n=length(survdat[,2])
s=survdat[,2]
cen=survdat[,3]
nn=diff(match(unique(id),id))
nn[length(nn)+1]=length(id)-sum(nn)
X2=as.matrix(survdat[,4:dim(survdat)[2]])
p1=dim(X1)[2]
p2=dim(X2)[2]
b1=likeests$b1[,1]
sigu=likeests$sigu
vare=likeests$vare
b2=likeests$b2[,1]
haz=likeests$haz
sf=likeests$sf
rs=likeests$rs
N=sum(nn)
lat=1
g=gauss.quad.prob(lgpt,"normal",sigma=sqrt(0.5))
ab=g$nodes
w=g$weights*sqrt(pi)
gmat=matrix(0,lgpt^ran,ran)
gmat[,1]=rep(ab,each=lgpt^(ran-1))
gmat[,2]=rep(ab,lgpt)
w=as.vector(w%x%w)
gmat[,3]=rep(ab,each=lgpt)
w=as.vector(w%x%g$weights*sqrt(pi))
l1=0
l2=0
r=Y-X1%*%b1
Dtt=getD(ran,tt,cp)
Dttb=t(Dtt)
Ds=getD(ran,s,cp) 
Dsf=getD(ran,sf,cp)
cnn=c(0,cumsum(nn))
b2x=X2%*%b2[1:p2]
if(p2==0){b2x=matrix(0,n,1)}
varei=vare*diag(max(nn))
cov=sigu%*%Dtt
tcov=Dttb%*%sigu
for (i in 1:n){
rv=r[(cnn[i]+1):cnn[i+1]]
ttv=Dttb[(cnn[i]+1):cnn[i+1],]
W21=cov[,(cnn[i]+1):cnn[i+1]]
W12=tcov[(cnn[i]+1):cnn[i+1],]
W11=ttv%*%W21+varei[1:nn[i],1:nn[i]]
if(nn[i]==1){
W3=W12/W11
cvch=chol((sigu-tcrossprod(W21,W3))*2)
cm=matrix(W3*rv,lgpt^ran,ran,TRUE)}
else{W3=solve(W11,W12)
cvch=chol((sigu-W21%*%W3)*2)
cm=matrix(rv%*%W3,lgpt^ran,ran,TRUE)}
newu=gmat%*%cvch+cm
DUs=newu%*%Ds[,i]
DUsf=newu%*%Dsf[,1:rs[i]]
ss=exp(b2x[i,])*exp(b2[p2+lat]*DUsf)%*%haz[1:rs[i]]
den=sum(exp(cen[i]*(b2[p2+lat]*DUs+b2x[i,]))*(haz[rs[i]]^cen[i])*w*exp(-ss))
l2=l2+0
if(den>0){l2=l2+log(den)}
l1=l1-nn[i]*0.5*log(2*pi)-0.5*log(det(W11))-0.5*sum(rv*solve(W11,rv))
}
ll=l1+l2-0.5*ran*n*log(pi)
list(log.like=ll,longlog.like=l1,survlog.like=l2)
}

"sort.dat"<-function(longdat,survdat){
sort.long=matrix(0,dim(longdat)[1],dim(longdat)[2])
id=longdat[,1]
nn=diff(match(unique(id),id))
nn[length(nn)+1]=length(id)-sum(nn)
id=rep(survdat[,2],nn)
sort.long=longdat[order(id),]
sort.surv=matrix(0,dim(survdat)[1],dim(survdat)[2])
sort.surv[,c(1,3:(dim(survdat)[2]))]=as.matrix(survdat[order(survdat[,2]),c(1,3:(dim(survdat)[2]))])
sort.surv[,2]=sort(survdat[,2])
list(long.s=data.frame(sort.long),surv.s=data.frame(sort.surv))
}

sort=sort.dat(longdat,survdat) 
longdat=as.matrix(sort$long.s)
survdat=as.matrix(sort$surv.s)
p2=dim(survdat)[2]-3
ldaests=longst(longdat,ran=ran,cp=cp)
survests=survst(survdat)
sep.ll=ldaests$log.like+survests$log.like
paraests=c(ldaests,survests)
jointests=em.alg(longdat,survdat,ran,paraests,gpt,max.it,tol,cp)
likeests<-c(jointests,list(rs=survests$rs,sf=survests$sf))
b1<-jointests$b1
sigu<-jointests$sigu
rownames(b1)<-c(1:(dim(longdat)[2]-3))
jointests=list(b1=b1,b2=jointests$b2[1:p2,],gamma=jointests$b2[(p2+1),],vare=jointests$vare,V=sigu,conv=jointests$conv,iters=jointests$iters)
jointll=jlike(longdat,survdat,ran,likeests,lgpt,cp)
list(ldaests=sep(ldaests,longsep),survests=sep(survests,survsep),sep.ll=sep.ll,jointests=jointests,joint.ll=jointll$log.like)
}

