"joint"<-function(longdat,survdat,longsep=FALSE,survsep=FALSE,gpt=3,max.it=200,tol=0.001,lgpt=10,model=c("intslope","int","quad"),sepassoc=FALSE){

model<-match.arg(model)
if(model!="intslope"&&model!="int"&&model!="quad")
{stop(paste("Unknown model", model))}
ran=2
if(model=="int"){ran=1}
if(model=="quad"){ran=3}

lat=ran
if(!sepassoc){lat=1}

"sep"<-function(ests,logical){
  if(logical==FALSE){ests="No separate results requested"}
  ests}

"longst"<-function(longdat,model,ran){
id=longdat[,1]
Y=longdat[,2]
X1=longdat[,4:dim(longdat)[2]]
tt=longdat[,3]
if(model=="int"){
long.start=lme(Y~X1-1,random=~1|id,method="ML")
sigu=as.matrix(as.double(VarCorr(long.start)[1,1]))
}
else if(model=="quad"){tt2=tt^2
long.start=lme(Y~X1-1,random=~(tt+tt2)|id,method="ML")
sigu=diag(as.double(VarCorr(long.start)[1:3,1]))
rho=as.double(c(VarCorr(long.start)[2,3],VarCorr(long.start)[3,3:4]))
v=tcrossprod(diag(sqrt(sigu)))*upper.tri(sigu)
sigu[upper.tri(sigu)]=v[v!=0]*rho
sigu=sigu+t(sigu)-diag(as.double(VarCorr(long.start)[1:3,1]))}
else{long.start=lme(Y~X1-1,random=~tt|id,method="ML")
sigu=diag(as.double(VarCorr(long.start)[1:2,1]))
rho=as.double(VarCorr(long.start)[2,3])
sigu[sigu==0]=sqrt(sigu[1,1]*sigu[2,2])*rho}
rownames(sigu)<-paste("U",0:(ran-1),sep='')
colnames(sigu)<-paste("U",0:(ran-1),sep='')
vare=long.start$sigma^2
ll=long.start$logLik
b1=fixef(long.start)
names(b1)<-NULL
list(b1=data.frame(b1),vare=vare,V=sigu,log.like=ll)
}

"survst"<-function(survdat){
n=length(survdat[,2])
s=survdat[,2]
cen=survdat[,3]
if(cen[1]==0){cen[1]=1}
p2=dim(survdat)[2]-3
if(p2==0){surv.start<-coxph(Surv(s,cen)~0)}
if(p2>0){
  X2=as.matrix(survdat[,4:dim(survdat)[2]])
  surv.start<-coxph(Surv(s,cen)~X2)}
alpha.0=basehaz(surv.start,FALSE)
nf=length(alpha.0[,2])
haz=diff(c(0,alpha.0[,1]))
sf=alpha.0[,2]
rs=rep(1:nf,c(diff(match(sf,s)),n+1-match(sf,s)[nf]))
nev=diff(c(match(1:length(sf),match(s[cen==1],sf)),sum(cen)+1))
b2=coef(surv.start)
names(b2)<-NULL
noties=(nf==sum(cen))
if(p2==0){ll=surv.start$loglik-sum(cen)}
else{if(noties){ll=surv.start$loglik[2]-sum(cen)}
else{ll=tiedsurvlike(survdat,b2,haz,sf,rs)}}
list(b2=b2,haz=haz,rs=rs,sf=sf,nev=nev,log.like=ll)
}

"tiedsurvlike"<-function(survdat,b2,haz,sf,rs){
s=survdat[,2]
cen=survdat[,3]
if(cen[1]==0){cen[1]=1}
p2=dim(survdat)[2]-3
if(p2==0){X2=0
          bX=0}
if(p2>0){X2=as.matrix(survdat[,4:dim(survdat)[2]])
bX=X2%*%b2}
f=match(s,sf)*cen
f[is.na(f)]=0
chaz=cumsum(haz)
l1=log(haz[f])+bX[cen==1]
l2=chaz[rs]*exp(bX)
ll=sum(l1)-sum(l2)
ll
}

"em.alg"<-function(longdat,survdat,ran,paraests,gpt,max.it,tol){
id=longdat[,1]
Y=longdat[,2]
tt=longdat[,3]
X1=longdat[,4:dim(longdat)[2]]
n=length(survdat[,2])
s=survdat[,2]
cen=survdat[,3]
p1=dim(longdat)[2]-3
p2=dim(survdat)[2]-3
X2=0
if(p2>0){X2=as.matrix(survdat[,4:dim(survdat)[2]])}
else{b2x=matrix(0,n,1)}
b1=paraests$b1[,1]
sigu=paraests$V
tsigu=t(sigu)
vare=paraests$vare
b2=c(paraests$b2,rep(0,lat))
haz=paraests$haz
sf=paraests$sf
rs=paraests$rs
nev=paraests$nev
nn=diff(match(unique(id),id))
nn=c(nn,length(id)-sum(nn))
N=sum(nn)
g=gauss.quad.prob(gpt,"normal",sigma=sqrt(0.5))
ab=g$nodes
w=g$weights*sqrt(pi)
gmat=matrix(0,gpt^ran,ran)
gmat[,1]=rep(ab,each=gpt^(ran-1))
if(model!="int"){gmat[,2]=rep(ab,gpt)
w=as.vector(w%x%w)}
if(model=="quad"){gmat[,3]=rep(ab,each=gpt)
w=as.vector(w%x%g$weights*sqrt(pi))}
EU=matrix(0,n,ran)
EUU=matrix(0,n,sum(1:ran))
EexpU=matrix(0,n,length(haz))
EUexpU=matrix(0,n,ran)
EUUexpU=matrix(0,n,sum(1:ran))
r=Y-X1%*%b1
Dtt=getD(ran,tt)
Dtt2=t(Dtt)
if(model!="int"){Dttc=t(getD(sum(1:ran)-ran,tt))*tt}
Ds=getD(ran,s) 
Dst=t(Ds)
Dsf=getD(ran,sf)
Dsf2=Dsf^2
Dsfc=t(t(Dsf)*sf)
Dnsf=matrix(1,ran,length(sf))
s1=rep(1:(ran-1),(ran-1):1)
s2=sequence((ran-1):1)+rep(1:(ran-1),(ran-1):1)
cnn=c(0,cumsum(nn))
Inn=diag(max(nn))
conv=FALSE
for (it in 1:max.it){
if(p2>0){b2x=X2%*%b2[1:p2]}
eb2x=exp(b2x)
varei=vare*Inn
cov=sigu%*%Dtt
tcov=Dtt2%*%sigu
DH=Dnsf*rep(haz,each=ran)
for (i in 1:n){
rv=r[(cnn[i]+1):cnn[i+1]]
ttv=Dtt2[(cnn[i]+1):cnn[i+1],]
W21=cov[,(cnn[i]+1):cnn[i+1]]
W12=tcov[(cnn[i]+1):cnn[i+1],]
if(model=="int"){W11=tcrossprod(ttv,W21)+varei[1:nn[i],1:nn[i]]}
else{W11=ttv%*%W21+varei[1:nn[i],1:nn[i]]}
if(nn[i]==1){
W3=W12/W11
if(model=="int"){cvch=sqrt((sigu-tcrossprod(W21,W3))*2)}
else{cvch=chol((sigu-tcrossprod(W21,W3))*2)}
cm=matrix(W3*rv,gpt^ran,ran,TRUE)}
else{W3=solve(W11,W12)
if(model=="int"){cvch=sqrt((sigu-W21%*%W3)*2)}
else{cvch=chol((sigu-W21%*%W3)*2)}
cm=matrix(rv%*%W3,gpt^ran,ran,TRUE)}
newu=gmat%*%cvch+cm
newu2=newu^2
if(model!="int"){
newu2=cbind(newu2,newu[,s1]*newu[,s2])}
egDUs=1
if(cen[i]==1){egDUs=exp(newu%*%(Dst[i,]*b2[(p2+1):(p2+lat)]))}
egDUsf=exp(newu%*%(Dsf[,1:rs[i]]*b2[(p2+1):(p2+lat)]))
ess=exp(-(eb2x[i,]*egDUsf)%*%haz[1:rs[i]])
f=egDUs*ess*w
den=sum(f)
EU[i,1:ran]=f[,1]%*%newu/den
EUU[i,1:sum(1:ran)]=f[,1]%*%newu2/den
C=egDUsf[,1:rs[i]]
EexpU[i,1:rs[i]]=f[,1]%*%C/den
if(model=="int"){
EUexpU[i,1]=sum(f[,1]%*%(newu[,1]*C)*haz[1:rs[i]])/den
EUUexpU[i,1]=sum(f[,1]%*%(newu[,1]^2*C)*haz[1:rs[i]])/den} 
else{
EUexpU[i,1:ran]=rowSums(crossprod(newu*f[,1],C)*Dsf[,1:rs[i]]*DH[,1:rs[i]])/den 
EUUexpU[i,1:ran]=rowSums(crossprod(newu2[,1:ran]*f[,1],C)*Dsf2[,1:rs[i]]*DH[,1:rs[i]])/den
if(model=="intslope"){EUUexpU[i,ran+1]=2*sum(f[,1]%*%(newu2[,ran+1]*C)*haz[1:rs[i]]*sf[1:rs[i]])/den}
else{EUUexpU[i,(ran+1):sum(1:ran)]=2*rowSums(crossprod(newu2[,(ran+1):sum(1:ran)]*f[,1],C)*Dsfc[,1:rs[i]]*DH[,1:rs[i]])/den}
}}
parac<-data.frame(c(b1,b2,vare,sigu))
EexpUi=colSums(t(EexpU)*haz)
haz=nev/colSums(EexpU*eb2x[,1])
EUmat<-apply(EU,2,rep,nn)
EUUmat<-apply(EUU,2,rep,nn)
Ut=rowSums(EUmat*Dtt2)
UUt=rowSums(EUUmat[,1:ran]*Dtt2^2)
UUt2=0
if(model!="int"){UUt2=rowSums(EUUmat[,(ran+1):sum(1:ran)]*Dttc)}
b1=solve(crossprod(X1),crossprod(X1,Y-Ut))
r=Y-X1%*%b1
vare=sum(r^2-2*r*Ut+UUt+2*UUt2)/N
diag(sigu)<-colMeans(EUU)[1:ran]
if(model!="int"){
sigu[lower.tri(sigu)]=colMeans(EUU)[-(1:ran)]
sigu[upper.tri(sigu)]=t(sigu)[upper.tri(sigu)]}
fd<-vector("numeric",p2+ran)
sd<-matrix(0,p2+ran,p2+ran)
fd[(p2+1):(p2+ran)]=colSums(cen*(EU*t(Ds)))-colSums(eb2x[,1]*EUexpU)
if(model!="int"){sd[(p2+1):(p2+ran),(p2+1):(p2+ran)][upper.tri(sd[(p2+1):(p2+ran),(p2+1):(p2+ran)])]=-colSums(eb2x[,1]*0.5*EUUexpU)[(ran+1):sum(1:ran)]}
if(p2>0){
fd[1:p2]=c(colSums((cen*X2)-(X2*eb2x[,1]*EexpUi)))
sd[(1:p2),(p2+1):(p2+ran)]=-t(X2)%*%(eb2x[,1]*EUexpU)
sd=sd+t(sd)
for (i in 1:p2){
for (j in 1:p2){
sd[i,j]=-(sum(X2[,i]*X2[,j]*eb2x[,1]*EexpUi))}}}
if(model=="int"){sd[(p2+1),(p2+1)]=-colSums(eb2x[,1]*EUUexpU)[1:ran]}
else{diag(sd[(p2+1):(p2+ran),(p2+1):(p2+ran)])=-colSums(eb2x[,1]*EUUexpU)[1:ran]}
if(!sepassoc){if(model=="int"){fd=fd
                               sd=sd}
              else{fd[p2+1]=sum(fd[(p2+1):(p2+ran)])
              fd=fd[1:(p2+1)]
                    if(p2>1){sd[1:p2,p2+1]=rowSums(sd[(1:p2),(p2+1):(p2+ran)])}
                   else{sd[1:p2,p2+1]=sum(sd[(1:p2),(p2+1):(p2+ran)])}
              sd[p2+1,1:p2]=sd[1:p2,p2+1]
              sd[p2+1,p2+1]=sum(sd[(p2+1):(p2+ran),(p2+1):(p2+ran)])
              sd=sd[1:(p2+1),1:(p2+1)]
                 }
            }
b2=b2-solve(sd,fd)
para<-data.frame(c(b1,b2,vare,sigu))
dd=abs(parac-para)
if(max(dd)<tol){conv=TRUE
break}
}
if(conv!=TRUE){print("Not converged")}
list(b1=data.frame(b1),b2=data.frame(b2),vare=vare,sigu=sigu,haz=haz,conv=conv,iters=it)
}

"getD"<-function(q,arg){D=matrix(0,q,length(arg))
for(i in 1:q){D[i,]=arg^(i-1)}
D}

"jlike"<-function(longdat,survdat,ran,likeests,lgpt){
id=longdat[,1]
Y=longdat[,2]
tt=longdat[,3]
X1=as.matrix(longdat[,4:dim(longdat)[2]])
n=length(survdat[,2])
s=survdat[,2]
cen=survdat[,3]
nn=diff(match(unique(id),id))
nn[length(nn)+1]=length(id)-sum(nn)
p1=dim(longdat)[2]-3
p2=dim(survdat)[2]-3
X2=0
if(p2>0){X2=as.matrix(survdat[,4:dim(survdat)[2]])}
b1=likeests$b1[,1]
sigu=likeests$sigu
vare=likeests$vare
b2=likeests$b2[,1]
haz=likeests$haz
sf=likeests$sf
rs=likeests$rs
N=sum(nn)
g=gauss.quad.prob(lgpt,"normal",sigma=sqrt(0.5))
ab=g$nodes
w=g$weights*sqrt(pi)
gmat=matrix(0,lgpt^ran,ran)
gmat[,1]=rep(ab,each=lgpt^(ran-1))
if(model!="int"){gmat[,2]=rep(ab,lgpt)
w=as.vector(w%x%w)}
if(model=="quad"){gmat[,3]=rep(ab,each=lgpt)
w=as.vector(w%x%g$weights*sqrt(pi))}
l1=0
l2=0
r=Y-X1%*%b1
Dtt=getD(ran,tt)
Dtt2=t(Dtt)
Ds=getD(ran,s) 
Dst=t(Ds)
Dsf=getD(ran,sf)
cnn=c(0,cumsum(nn))
b2x=X2%*%b2[1:p2]
if(p2==0){b2x=matrix(0,n,1)}
varei=vare*diag(max(nn))
cov=sigu%*%Dtt
tcov=Dtt2%*%sigu
for (i in 1:n){
rv=r[(cnn[i]+1):cnn[i+1]]
ttv=Dtt2[(cnn[i]+1):cnn[i+1],]
W21=cov[,(cnn[i]+1):cnn[i+1]]
W12=tcov[(cnn[i]+1):cnn[i+1],]
if(model=="int"){W11=tcrossprod(ttv,W21)+varei[1:nn[i],1:nn[i]]}
else{W11=ttv%*%W21+varei[1:nn[i],1:nn[i]]}
if(nn[i]==1){
W3=W12/W11
if(model=="int"){cvch=sqrt((sigu-tcrossprod(W21,W3))*2)}
else{cvch=chol((sigu-tcrossprod(W21,W3))*2)}
cm=matrix(W3*rv,lgpt^ran,ran,TRUE)}
else{W3=solve(W11,W12)
if(model=="int"){cvch=sqrt((sigu-W21%*%W3)*2)}
else{cvch=chol((sigu-W21%*%W3)*2)}
cm=matrix(rv%*%W3,lgpt^ran,ran,TRUE)}
newu=gmat%*%cvch+cm
DUs=newu%*%Ds[,i]
DUsf=newu%*%Dsf[,1:rs[i]]
ss=exp(b2x[i,])*exp(newu%*%(Dsf[,1:rs[i]]*b2[(p2+1):(p2+lat)]))%*%haz[1:rs[i]]
den=sum(exp(cen[i]*(newu%*%(Dst[i,]*b2[(p2+1):(p2+lat)])+b2x[i,]))*(haz[rs[i]]^cen[i])*w*exp(-ss))
l2=l2+0
if(den>0){l2=l2+log(den)}
l1=l1-nn[i]*0.5*log(2*pi)-0.5*log(det(W11))-0.5*sum(rv*solve(W11,rv))
}
ll=l1+l2-0.5*ran*n*log(pi)
list(log.like=ll,longlog.like=l1,survlog.like=l2)
}

"sort.dat"<-function(longdat,survdat){
sort.long=matrix(0,dim(longdat)[1],dim(longdat)[2])
id=longdat[,1]
nn=diff(match(unique(id),id))
nn[length(nn)+1]=length(id)-sum(nn)
id=rep(survdat[,2],nn)
sort.long=longdat[order(id),]
sort.surv=matrix(0,dim(survdat)[1],dim(survdat)[2])
sort.surv[,c(1,3:(dim(survdat)[2]))]=as.matrix(survdat[order(survdat[,2]),c(1,3:(dim(survdat)[2]))])
sort.surv[,2]=sort(survdat[,2])
list(long.s=data.frame(sort.long),surv.s=data.frame(sort.surv))
}

sort <- sort.dat(longdat,survdat) 
longdat <- as.matrix(sort$long.s)
survdat <- as.matrix(sort$surv.s)
p2 <- dim(survdat)[2]-3
ldaests <- longst(longdat,model=model,ran=ran)
survests <- survst(survdat)
sep.ll <- ldaests$log.like+survests$log.like
paraests <- c(ldaests,survests)
jointests <- em.alg(longdat,survdat,ran,paraests,gpt,max.it,tol)
likeests<-c(jointests,list(rs=survests$rs,sf=survests$sf))
b1<-jointests$b1
sigu<-jointests$sigu
rownames(b1)<-c(1:(dim(longdat)[2]-3))
if(p2>0){b2<-jointests$b2[1:p2,]}
else{b2<-NULL}
jointests <- list(b1=b1,b2=b2,gamma=jointests$b2[(p2+1):(p2+lat),],vare=jointests$vare,V=sigu,conv=jointests$conv,iters=jointests$iters)
jointll <- jlike(longdat,survdat,ran,likeests,lgpt)
list(ldaests=sep(ldaests,longsep),survests=sep(survests,survsep),sep.ll=sep.ll,jointests=jointests,joint.ll=jointll$log.like,model=model)
}

